#version 120 

attribute vec4 position;
attribute vec4 vertexColor;
attribute vec4 texCoord;
attribute vec4 vertexColor2;

uniform mat4 modelview; 
uniform mat4 projection;
uniform float alpha;
uniform float gamma_inv;

varying vec4 frontColor;
varying vec4 fogColor;
varying float fragAlpha; 
varying float gamma_i;

void main(void)
{
	gamma_i = gamma_inv;
	frontColor = vertexColor;
	fogColor = vertexColor2;
	fragAlpha = alpha;
	gl_TexCoord[0] = texCoord;
	gl_Position = projection * modelview * position;
}
